// dark & light mode

const themeToggle = document.getElementById("themeToggle");
const sunIcon = themeToggle.querySelector(".sun-icon");
const moonIcon = themeToggle.querySelector(".moon-icon");
// get all element
const htmlEl = document.documentElement;

const savedTheme = localStorage.getItem("theme");
const prefersDark = window.matchMedia("(prefers-color-scheme: dark)").matches;

if (savedTheme) {
  htmlEl.className = savedTheme;
} else if (prefersDark) {
  htmlEl.className = "dark";
} else {
  htmlEl.className = "light";
}

updateButtonIcons();

themeToggle.addEventListener("click", () => {
  if (htmlEl.classList.contains("light")) {
    htmlEl.className = "dark";
    localStorage.setItem("theme", "dark");
  } else {
    htmlEl.className = "light";
    localStorage.setItem("theme", "light");
  }
  updateButtonIcons();
});

function updateButtonIcons() {
  if (htmlEl.classList.contains("dark")) {
    sunIcon.style.display = "inline";
    moonIcon.style.display = "none";
  } else {
    sunIcon.style.display = "none";
    moonIcon.style.display = "inline";
  }
}

// nav menu for moblie

const mobileMenuTrigger = document.getElementById("mobileMenuTrigger");
const mainNav = document.getElementById("mainNav");
mobileMenuTrigger.addEventListener("click", () => {
  mainNav.classList.toggle("active");
  mobileMenuTrigger.setAttribute(
    "aria-expanded",
    mainNav.classList.contains("active")
  );
});

// update the footer year

document.getElementById("currentYear").textContent = new Date().getFullYear();

// scroll animation

const scrollElements = document.querySelectorAll(".scroll-animate");
const elementInView = (el, dividend = 1) => {
  const elementTop = el.getBoundingClientRect().top;
  return (
    elementTop <=
    (window.innerHeight || document.documentElement.clientHeight) / dividend
  );
};
const displayScrollElement = (element) => {
  element.classList.add("animated");
};
const hideScrollElement = (element) => {};
const handleScrollAnimation = () => {
  scrollElements.forEach((el) => {
    if (elementInView(el, 1.25)) {
      displayScrollElement(el);
    } else {
    }
  });
};
window.addEventListener("scroll", () => {
  handleScrollAnimation();
});
handleScrollAnimation();
